
Public Class Url
    Private m_Url As String

    Public Sub New(ByVal UrlString As String)
        m_Url = UrlString
    End Sub

    Public ReadOnly Property Secure() As Boolean
        Get
            If m_Url.IndexOf("https://") <> -1 Then
                Return True
            End If
            Return False
        End Get
    End Property

    Public ReadOnly Property FullUrl() As String
        Get
            Return m_Url
        End Get
    End Property

    Public ReadOnly Property Server() As String
        Get
            Dim s As String = m_Url
            ' Convert to lowercase
            s = s.ToLower

            ' Strip off http designator
            Dim p As Long = s.IndexOf("http://")
            If p = -1 Then
                p = s.IndexOf("https://")
                If p <> -1 Then
                    s = s.Substring(p + 8)
                End If
            Else
                s = s.Substring(p + 7)
            End If

            ' Check for first colon, if found return everything before
            p = s.IndexOf(":")
            If p <> -1 Then Return s.Substring(0, p)

            ' Check for first slash, if found return everything before
            p = s.IndexOf("/")
            If p <> -1 Then Return s.Substring(0, p)

            ' Whatever is left is host
            Return s
        End Get
    End Property

    Public ReadOnly Property Port() As Integer
        Get
            Dim s As String = m_Url
            ' Convert to lowercase
            s = s.ToLower

            ' Strip off http designator
            Dim p As Long = s.IndexOf("http://")
            If p = -1 Then
                p = s.IndexOf("https://")
                If p <> -1 Then
                    s = s.Substring(p + 8)
                End If
            Else
                s = s.Substring(p + 7)
            End If

            ' Check for first colon, if found return value of what's after
            p = s.IndexOf(":")
            If p <> -1 Then
                s = s.Substring(p + 1)
                Return Val(s)
            End If

            ' Return default ports
            If Me.Secure Then
                Return 443
            Else
                Return 80
            End If
        End Get
    End Property

    Public ReadOnly Property Path() As String
        Get
            Dim s As String = m_Url
            ' Convert to lowercase
            s = s.ToLower

            ' Find first "//"
            Dim p As Long = s.IndexOf("//")
            If p <> -1 Then s = s.Substring(p + 2)

            ' Find first "/" in what's left, if found return everything before
            p = s.IndexOf("/")
            If p <> -1 Then Return s.Substring(p)

            ' Whatever is left is path
            Return "/"
        End Get
    End Property

    Public ReadOnly Property Filename() As String
        Get
            Dim n, m As Long
            n = InStrRev(m_Url, "\")
            m = InStrRev(m_Url, "/")
            If m > n Then n = m
            Return Mid(m_Url, n + 1)
        End Get
    End Property

End Class
