Imports Dart.PowerTCP.SslSockets

Public Class frmMain
    Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

    Public Sub New()
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call

    End Sub

    'Form overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents txtUrl As System.Windows.Forms.TextBox
    Friend WithEvents lblUrl As System.Windows.Forms.Label
    Friend WithEvents prgBytes As System.Windows.Forms.ProgressBar
    Friend WithEvents cmdGet As System.Windows.Forms.Button
    Friend WithEvents cmdCancel As System.Windows.Forms.Button
    Friend WithEvents lblStatus As System.Windows.Forms.Label
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Dim resources As System.Resources.ResourceManager = New System.Resources.ResourceManager(GetType(frmMain))
        Me.txtUrl = New System.Windows.Forms.TextBox()
        Me.lblUrl = New System.Windows.Forms.Label()
        Me.prgBytes = New System.Windows.Forms.ProgressBar()
        Me.cmdGet = New System.Windows.Forms.Button()
        Me.cmdCancel = New System.Windows.Forms.Button()
        Me.lblStatus = New System.Windows.Forms.Label()
        Me.SuspendLayout()
        '
        'txtUrl
        '
        Me.txtUrl.Location = New System.Drawing.Point(8, 40)
        Me.txtUrl.Name = "txtUrl"
        Me.txtUrl.Size = New System.Drawing.Size(336, 20)
        Me.txtUrl.TabIndex = 0
        Me.txtUrl.Text = ""
        '
        'lblUrl
        '
        Me.lblUrl.Location = New System.Drawing.Point(8, 16)
        Me.lblUrl.Name = "lblUrl"
        Me.lblUrl.Size = New System.Drawing.Size(336, 24)
        Me.lblUrl.TabIndex = 1
        Me.lblUrl.Text = "Enter URL, then Press ""Get"""
        '
        'prgBytes
        '
        Me.prgBytes.Location = New System.Drawing.Point(8, 72)
        Me.prgBytes.Name = "prgBytes"
        Me.prgBytes.Size = New System.Drawing.Size(336, 24)
        Me.prgBytes.TabIndex = 2
        '
        'cmdGet
        '
        Me.cmdGet.Location = New System.Drawing.Point(176, 131)
        Me.cmdGet.Name = "cmdGet"
        Me.cmdGet.Size = New System.Drawing.Size(80, 24)
        Me.cmdGet.TabIndex = 3
        Me.cmdGet.Text = "Get"
        '
        'cmdCancel
        '
        Me.cmdCancel.Location = New System.Drawing.Point(264, 131)
        Me.cmdCancel.Name = "cmdCancel"
        Me.cmdCancel.Size = New System.Drawing.Size(80, 24)
        Me.cmdCancel.TabIndex = 4
        Me.cmdCancel.Text = "Cancel"
        '
        'lblStatus
        '
        Me.lblStatus.Location = New System.Drawing.Point(8, 101)
        Me.lblStatus.Name = "lblStatus"
        Me.lblStatus.Size = New System.Drawing.Size(336, 16)
        Me.lblStatus.TabIndex = 5
        Me.lblStatus.TextAlign = System.Drawing.ContentAlignment.MiddleCenter
        '
        'frmMain
        '
        Me.AcceptButton = Me.cmdGet
        Me.AutoScaleBaseSize = New System.Drawing.Size(5, 13)
        Me.ClientSize = New System.Drawing.Size(352, 166)
        Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.lblStatus, Me.cmdCancel, Me.cmdGet, Me.prgBytes, Me.lblUrl, Me.txtUrl})
        Me.Icon = CType(resources.GetObject("$this.Icon"), System.Drawing.Icon)
        Me.Name = "frmMain"
        Me.StartPosition = System.Windows.Forms.FormStartPosition.CenterScreen
        Me.Text = "."
        Me.ResumeLayout(False)

    End Sub

#End Region

    Const APPNAME = "PowerTCP SaveURL Sample"
    Dim Killing As Boolean = False
    Dim Aborted As Boolean = False

    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Text = APPNAME
        cmdGet.Enabled = True
        cmdCancel.Enabled = False
        GetSettings()
        lblStatus.Text = "Ready"
    End Sub

    Private Sub GetSettings()
        txtUrl.Text = GetDartSampleSetting(APPNAME, "Url", "http://www.rbrvs.com/rbrvs/iqsys00.xls")
    End Sub

    Private Sub SaveSettings()
        SaveDartSampleSetting(APPNAME, "Url", txtUrl.Text)
    End Sub

    Private Sub txtUrl_Enter(ByVal sender As Object, ByVal e As System.EventArgs) Handles txtUrl.Enter
        With txtUrl
            .SelectionStart = 0
            .SelectionLength = .Text.Length
        End With
    End Sub

    Private Sub cmdCancel_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdCancel.Click
        Aborted = True
        cmdCancel.Enabled = False
    End Sub


    Private Sub cmdGet_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmdGet.Click
        cmdGet.Enabled = False
        cmdCancel.Enabled = True
        prgBytes.Value = 0
        SaveUrl(txtUrl.Text)
        lblStatus.Text = "Ready"
        prgBytes.Value = 0
        cmdGet.Enabled = True
        cmdCancel.Enabled = False
        SaveSettings()
        If Killing Then Close()
    End Sub

    Private Sub SaveUrl(ByVal UrlString As String)
        ' Parse information from Url
        Dim Url As New Url(txtUrl.Text)
        Try
            ' Create as Tcp control to use to retrieve page
            Dim Browser As New Tcp()
            ' Set 30 second timeout
            Browser.ReceiveTimeout = 30000
            ' Set security
            If Url.Secure Then
                Browser.SecureProtocol = SecureProtocol.Auto
            Else
                Browser.SecureProtocol = SecureProtocol.None
            End If
            ' Connect to server on specified port
            lblStatus.Text = "Connecting to " + Url.Server + " on port " + Url.Port.ToString + " ..."
            Browser.Connect(Url.Server, Url.Port)
            lblStatus.Text = "Sending request ..."
            ' Make request
            Dim Request As String = "GET " + Url.Path + " HTTP/1.0" + vbCrLf
            Request += "Host: " + Url.Server + vbCrLf
            Request += vbCrLf
            ' Send request
            Browser.Send(Request)
            ' Get the header
            Dim Found As Boolean
            Dim Header As String = Browser.Stream.Read(vbCrLf + vbCrLf, 50000, Found)
            If Found Then
                ' Get the response code
                If GetResponseCode(Header) < 300 Then
                    ' Get the size of the requested file
                    Dim ContentLength As Long = GetContentLength(Header)
                    If ContentLength > 0 Then
                        lblStatus.Text = "Retrieving " + ContentLength.ToString + " bytes ..."
                    Else
                        lblStatus.Text = "Retrieving ??? bytes ..."
                    End If
                    If ContentLength > 0 Then prgBytes.Maximum = ContentLength
                    ' Get the filename (if any) from the header
                    Dim SaveFileName As String = Url.Filename
                    ' Create Temp File
                    Dim TempFileName As String = Application.StartupPath + "\temp" + System.DateTime.Now.Ticks.ToString
                    Dim File As New IO.FileStream(TempFileName, IO.FileMode.Create, IO.FileAccess.Write)
                    Dim Bytes(8191) As Byte
                    Dim Count As Long
                    Aborted = False
                    ' Retrieve until server closes connection or cancel is pressed
                    Do While cmdCancel.Enabled And Browser.Connected
                        Count = Browser.Stream.Read(Bytes, 0, Bytes.Length)
                        File.Write(Bytes, 0, Count)
                        prgBytes.Increment(Count)
                    Loop
                    Browser.Close()
                    File.Close()
                    ' If not aborted prompt for filename and move temp file
                    If Not Aborted Then
                        Dim dlgSave As New SaveFileDialog()
                        dlgSave.OverwritePrompt = True
                        If SaveFileName <> "" Then
                            dlgSave.FileName = Application.StartupPath + "\" + SaveFileName
                        End If
                        If dlgSave.ShowDialog = DialogResult.OK Then
                            SaveFileName = dlgSave.FileName
                            If IO.File.Exists(SaveFileName) Then IO.File.Delete(SaveFileName)
                            System.IO.File.Move(TempFileName, SaveFileName)
                        Else
                            Aborted = True
                        End If
                    End If
                    If Aborted Then System.IO.File.Delete(TempFileName)
                Else
                    MsgBox(Header, MsgBoxStyle.Critical, "Server Error")
                End If
            Else
                MsgBox("Invalid Response (No Header Received)", MsgBoxStyle.Critical, "Invalid Response")
            End If
        Catch ex As Exception
            MsgBox(ex.Message, MsgBoxStyle.Critical, "Retrieve Error")
        End Try
    End Sub

    Private Function GetContentLength(ByVal Header As String) As Long
        Dim token As String = vbCrLf + "Content-Length: "
        Dim p As Long = Header.IndexOf(token)
        If p <> -1 Then
            Header = Header.Substring(p + token.Length)
            Return Val(Header)
        End If
        Return 0
    End Function

    Private Function GetResponseCode(ByVal Header As String) As Long
        Dim p As Long = Header.IndexOf(" ")
        If p <> -1 Then
            Header = Header.Substring(p)
            Return Val(Header)
        End If
        Return 400
    End Function

    Private Sub frmMain_Closing(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles MyBase.Closing
        If cmdCancel.Enabled Then
            cmdCancel.Enabled = False
            e.Cancel = True
            Aborted = True
            Killing = True
        End If
    End Sub
End Class
