Imports Microsoft.Win32

Module DartSampleUtils

    Public Sub AddToDebugLog(ByVal Filename As String, ByVal Entry As String, ByVal Sent As Boolean)
        Dim s As String
        ' If this us the result of an outgoing transmission, prepend the
        ' text with a right pointing arrow, otherwise use a left pointing
        ' arrow
        If Sent Then
            s += vbCrLf + "---> "
        Else
            s += vbCrLf + "<--- "
        End If
        s += Entry
        Dim Retry As Long
        Retry = 10
        Do While Retry > 0
            Try
                Dim Stream As New IO.FileStream(Filename, IO.FileMode.OpenOrCreate, IO.FileAccess.ReadWrite)
                Stream.Seek(0, IO.SeekOrigin.End)
                Stream.Write(System.Text.ASCIIEncoding.ASCII.GetBytes(s.ToCharArray), 0, System.Text.ASCIIEncoding.ASCII.GetByteCount(s.ToCharArray))
                Stream.Close()
                Retry = 0
            Catch ex As Exception
                Retry -= 1
                If Retry = 0 Then MsgBox(ex.Message, MsgBoxStyle.Critical, "Logfile Error")
            End Try
        Loop
    End Sub

    Public Function GetFilename(ByVal Path As String) As String
        Dim n, m As Long
        n = InStrRev(Path, "\")
        m = InStrRev(Path, "/")
        If m > n Then n = m
        GetFilename = Mid(Path, n + 1)
    End Function

    Public Function GetPath(ByVal Path As String) As String
        Dim n, m As Long
        n = InStrRev(Path, "\")
        m = InStrRev(Path, "/")
        If m > n Then n = m
        Return Path.Substring(0, n)
    End Function

    Public Sub SaveDartSampleSetting(ByVal APP_NAME As String, ByVal Keyname As String, ByVal Value As String)
        Dim Key As RegistryKey
        Try
            Key = Registry.CurrentUser.CreateSubKey("SOFTWARE").CreateSubKey("Dart").CreateSubKey("Sample Applications").CreateSubKey(APP_NAME)
            Key.SetValue(Keyname, Value)
        Catch
            Return
        End Try
    End Sub

    Public Sub SaveDartSampleSettingAsObject(ByVal APP_NAME As String, ByVal Keyname As String, ByVal Value As Object)
        Dim Key As RegistryKey
        Try
            Key = Registry.CurrentUser.CreateSubKey("SOFTWARE").CreateSubKey("Dart").CreateSubKey("Sample Applications").CreateSubKey(APP_NAME)
            Key.SetValue(Keyname, Value)
        Catch
            Return
        End Try
    End Sub

    Public Function GetDartSampleSettingAsObject(ByVal APP_NAME As String, ByVal Keyname As String, Optional ByVal DefVal As Object = VariantType.Null) As Object
        Dim Key As RegistryKey
        Try
            Key = Registry.CurrentUser.CreateSubKey("SOFTWARE").CreateSubKey("Dart").CreateSubKey("Sample Applications").CreateSubKey(APP_NAME)
            Return Key.GetValue(Keyname, DefVal)
        Catch
            Return DefVal
        End Try
    End Function


    Public Function GetDartSampleSetting(ByVal APP_NAME As String, ByVal Keyname As String, Optional ByVal DefVal As String = "") As String
        Dim Key As RegistryKey
        Try
            Key = Registry.CurrentUser.CreateSubKey("SOFTWARE").CreateSubKey("Dart").CreateSubKey("Sample Applications").CreateSubKey(APP_NAME)
            Return Key.GetValue(Keyname, DefVal)
        Catch
            Return DefVal
        End Try
    End Function

    Public Function GetTimeRemaining(ByVal StartTime As Long, ByVal Count As Long, ByVal Size As Long) As String
        If Size < 1 Then Return ""

        Dim ElapsedTime As Long
        ElapsedTime = System.DateTime.Now.Ticks - StartTime
        If ElapsedTime < 1 Then Return ""

        Dim Rate As Long
        Rate = (Count * 10000000) / ElapsedTime
        If Rate < 1 Then Return ""

        Dim BytesRemaining As Long
        BytesRemaining = Size - Count

        Dim tr As Long
        tr = BytesRemaining / Rate
        If tr < 0 Then tr = 0

        If tr > 3600 Then
            Return Format(tr / 3600, "0") & " Hours"
        ElseIf tr > 60 Then
            Return Format(tr / 60, "0") & " Minutes"
        Else
            Return Format(tr, "0") & " Seconds"
        End If
    End Function

    Public Function GetPercentage(ByVal Count As Long, ByVal Size As Long) As Long
        If Size > 0 Then
            Return (Count * 100) / Size
        Else
            Return 0
        End If
    End Function

    Public Function GetTransferRate(ByVal StartTime As Long, ByVal Count As Long) As String
        If StartTime < 0 Then Return ""
        Dim Elapsed As Long
        Dim rate As Long
        Elapsed = System.DateTime.Now.Ticks - StartTime
        If Elapsed > 0 Then rate = (Count * 10000000) / Elapsed

        If rate > 0 Then
            If rate > 1048576 Then
                Return Format(CDbl(rate / 1048576), "0.0") & " MBps"
            ElseIf rate > 1000 Then
                Return Format(CDbl(rate / 1024), "0.0") & " KBps"
            Else
                Return CStr(rate) & " Bps"
            End If
        Else
            Return ""
        End If
    End Function

    
End Module
